library(doParallel)
library(protr)
library(tidyverse)
library(seqinr)

cl <- makePSOCKcluster(15)
registerDoParallel(cl)
mm <- readRDS("models/ACCDQ_svm.rds")
input_fasta <- readFASTA("data/input.fasta")
input_fasta <- input_fasta[(sapply(input_fasta, protcheck))]

AAC <- t(sapply(input_fasta, extractAAC))
CTDC <- t(sapply(input_fasta, extractCTDC))
CTDT <- t(sapply(input_fasta, extractCTDT))
CTDD <- t(sapply(input_fasta, extractCTDD))
CTD <- cbind(CTDC, CTDT, CTDD)
CTriad <- t(sapply(input_fasta, extractCTriad))
DPC <- t(sapply(input_fasta, extractDC))
colnames(DPC)[3] <- "NA." ############## To rename the column for dipeptide NA.
colnames(DPC)[70] <- "ID.1" ############ To rename the column for dipeptide ID
QSO <- t(sapply(input_fasta, extractQSO))
hybrid <- as.data.frame(cbind(AAC, CTD, CTriad, DPC, QSO))

hybridFS <- select(hybrid, T, Grantham.Xr.T, R, hydrophobicity.Group3, Schneider.Xr.T, Schneider.Xr.R, polarity.Group1, Grantham.Xr.R, secondarystruct.Group3, normwaalsvolume.Group3, polarizability.Group3, Grantham.Xd.2, prop4.Tr2332, Schneider.Xd.2, prop2.Tr1331, polarizability.Group1, prop1.Tr1221, secondarystruct.Group1, VS555, prop5.G1.residue0, Grantham.Xd.1, TG, prop2.Tr2332, solventaccess.Group1, L, prop5.G1.residue100, prop3.Tr1331, normwaalsvolume.Group1, prop3.Tr2332, TT, Schneider.Xr.C, Grantham.Xr.C, prop4.Tr1331, prop1.Tr1331, C, solventaccess.Group3, prop7.G1.residue75, prop4.Tr1221, prop5.G2.residue0, H, prop1.G1.residue0, prop3.G3.residue0, AR, prop7.G2.residue0, prop1.G3.residue75, prop7.G3.residue0, prop2.Tr1221, LP, prop6.G1.residue0, prop3.G1.residue0, Schneider.Xr.H, LR, prop4.G3.residue0, polarity.Group2, prop2.G3.residue0, F, prop6.Tr1221, prop1.G3.residue0, RA, prop5.Tr1221, Grantham.Xr.D, Grantham.Xr.H, TV, RL, VT, prop5.Tr2332, Schneider.Xd.1, ER, Schneider.Xr.D, RG, M, DG, Grantham.Xr.F, prop7.Tr2332, prop7.Tr1221, Grantham.Xr.N, charge.Group3, hydrophobicity.Group2, prop3.G1.residue75, Schneider.Xr.F, I, Schneider.Xr.M, VS333, Schneider.Xr.L, Grantham.Xr.L, Schneider.Xr.I, Schneider.Xr.N, Grantham.Xr.P, Schneider.Xr.E, GR, prop3.G1.residue25, QR, prop1.Tr2332, prop1.G3.residue25, Schneider.Xr.P, RE, Grantham.Xr.M, TN, ST, Grantham.Xr.S, D, charge.Group1, Grantham.Xr.K, KP, Schneider.Xd.29, GT, Grantham.Xr.E, N, Grantham.Xr.I, NT, prop5.G1.residue75, PT, NG, VS613, VS313, Schneider.Xr.K, E, VS633, VS316, RQ, W, RS, RI, TS, RP, VS133, SR, ET, Grantham.Xd.29, RY, Schneider.Xd.6, RF, prop3.G3.residue100, K, prop4.G3.residue75, prop7.G2.residue100, prop2.G3.residue75, Schneider.Xd.28, prop1.G1.residue100, P, Grantham.Xr.G, Schneider.Xr.W, prop3.Tr1221, PR, prop7.G1.residue0, WR, Schneider.Xd.26, Schneider.Xd.30, Grantham.Xr.W, AT)

LayerBC_out <- predict(mm, hybridFS, type="prob")
LayerBC_out2 <- predict(mm, hybridFS)
LayerBCpred <- cbind(LayerBC_out, LayerBC_out2)
LayerBCpred <- cbind(ID=rownames(hybridFS), LayerBCpred)
rownames(LayerBCpred) <- NULL

colnames(LayerBCpred) <- c("ID", "P", "X", "Prediction")
is.num <- sapply(LayerBCpred, is.numeric)
LayerBCpred[is.num] <- lapply(LayerBCpred[is.num], round, 3)
write.csv(LayerBCpred, file='data/prediction_results.csv', row.names=FALSE)

